<?php

namespace App\Http\Controllers\API\Admin;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;


class ApprovesController extends Controller
{
   //approve candidate 
   public function candidate_approve(Request $request, $id)
   {
       //validate status input
       $request->validate(
           [
               'status'=>'required|min:4|max:20',
       
           ],
           [
               'status.required'=>'Status Field is required',
            
       ]);
       //Check for the data from the form
       $candidate = User::where('role','=','candidate')->find($id);
       $status = $request->input('status') ? $request->input('status') : $candidate->status;
       //update the user profile
       if($candidate !== null){
       $candidate->update([
           'status' => $status
       ]);


       //Return response back to Admin
       return response()->json([
           'status' => true,
           'message' => 'Candidate Approved'
       ]);

       } else
       {  
       
       //Return response back to Admin
       return response()->json([
           'status' => false,
           'message' => 'User Not a Candidate'
       ]);   
       }

   }

    //approve employer
    public function employer_approve(Request $request, $id)
    {
        //validate status input
       $request->validate(
           [
               'status'=>'required|min:4|max:20',
       
           ],
           [
               'status.required'=>'Status Field is required',
            
       ]);
        //Check for the data from the form
        $employer = User::where('role','=','employer')->find($id);
        $status = $request->input('status') ? $request->input('status') : $employer->status;
        //update the user profile
        if($employer !== null){
        $employer->update([
            'status' => $status
        ]);


        //Return response back to Admin
        return response()->json([
            'status' => true,
            'message' => 'Employer Approved'
        ]);

        } else
        {  
        
        //Return response back to Admin
        return response()->json([
            'status' => false,
            'message' => 'User Not an Employer'
        ]);   
        }
 
    }

    //approve BPO
    public function bpo_approve(Request $request, $id)
    {
       //validate status input
       $request->validate(
           [
               'status'=>'required|min:4|max:20',
       
           ],
           [
               'status.required'=>'Status Field is required',
            
       ]);
        //Check for the data from the form
        $bpo = User::where('role','=','bpo')->find($id);
        $status = $request->input('status') ? $request->input('status') : $bpo->status;
        //update the user profile
        if($bpo !== null){
        $bpo->update([
            'status' => $status
        ]);


        //Return response back to Admin
        return response()->json([
            'status' => true,
            'message' => 'BPO Approved'
        ]);

        } else
        {  
        
        //Return response back to Admin
        return response()->json([
            'status' => false,
            'message' => 'User Not a BPO'
        ]);   
        }
 
    }    

}
