<?php
namespace App\Http\Controllers\API\Admin;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;


class UserListingsController extends Controller
{
    //view all users 
    public function viewallusers()
    {
        try {
            $all_users_listings = User::where('role','!=','admin')->orderBy('firstname','ASC')->get();
            return response()->json([
                'status' => true,
                'data' => $all_users_listings,
            ]);
        }
        catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }
    //view all candidates
    public function viewcandidate()
    {
        try {
            $all_candidate_listings = User::where('role','=','candidate')->orderBy('firstname','ASC')->get();
            return response()->json([
                'status' => true,
                'data' => $all_candidate_listings,
            ]);
        }
        catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }

    //view all employer
    public function viewemployer()
    {
        try {
            $all_employer_listings = User::where('role','=','employer')->orderBy('firstname','ASC')->get();
            return response()->json([
                'status' => true,
                'data' => $all_employer_listings,
            ]);
        }
        catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }


    //view all BPO
    public function viewbpo()
    {
        try {
            $all_bpo_listings = User::where('role','=','bpo')->orderBy('firstname','ASC')->get();
            return response()->json([
                'status' => true,
                'data' => $all_bpo_listings,
            ]);
        }
        catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }


    
//update a candidate profile
    public function user_update(Request $request, $id)
    {
        
        try {
        
                //Check for the data from the form
                $profile = User::find($id);
                $firstname = $request->input('firstname') ? $request->input('firstname') : $profile->firstname;
                $lastname = $request->input('lastname') ? $request->input('lastname') : $profile->lastname;
                $phone_number = $request->input('phone_number') ? $request->input('phone_number') : $profile->phone_number;
                $subscription_type = $request->input('subscription_type') ? $request->input('subscription_type') : $profile->candidate->subscription_type;
                $verified_status = $request->input('verified_status') ? $request->input('verified_status') : $profile->candidate->verified_status;
                $bpo_id = $request->input('bpo_id') ? $request->input('bpo_id') : $profile->candidate->bpo_id;
                $profile_image = $request->input('profile_image') ? $request->input('profile_image') : $profile->candidate->profile_image;
                $resume = $request->input('resume') ? $request->input('resume') : $profile->candidate->resume;

                //update the user profile
                $profile->update([
                    'firstname' => $firstname,
                    'lastname' => $lastname,
                    'phone_number' => $phone_number,
                ]);

                $profile->candidate()->update([
                    'subscription_type' => $subscription_type,
                    'verified_status' => $verified_status,
                    'bpo_id' => $bpo_id,
                    'profile_image' => $profile_image,
                    'resume' => $resume,
                ]);

                //Return response back to Admin
                return response()->json([
                    'status' => true,
                    'message' => 'Profile successfully updated'
                ]);
            

        }
        catch(\Exception $e)
        {
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }

    }

    //account delete
    public function destroy(Request $request, $id)
    {
         //Check for the data from the form
         $user = User::find($id);
         $user->delete();
             //Return response back to Admin
             return response()->json([
                'status' => true,
                'message' => 'User Deleted Successfully'
            ]);
    }

}
