<?php

namespace App\Http\Controllers\Api\Candidate;

use App\Http\Controllers\Controller;
use App\Models\BPO;
use App\Models\Candidate;
use App\Models\User;
use Illuminate\Http\Request;

class CandidateBPOController extends Controller
{
    public function allBpo()
    {

        try {
//            //Get the current BPO
//            $candidate = Candidate::with('bpo')->where('user_id', auth()->id())->first();
//            $current_BPO = BPO::with('bpo')->where('user_id', $candidate->bpo->id)->first();
//            dd($current_BPO);

            //Get all the BPO's on the Platform and return the data so that the Candidate can use

            $bpo = BPO::all();
            return response()->json([
                'status' => true,
                'data' => $bpo
            ]);
        }catch (\Exception $e){
            return response()->json([
               'status' => false,
               'message' => $e->getMessage()
            ]);
        }

    }

    public function updateBPO(Request $request)
    {

        try {
            //Get the logged in user, use that information to update the candidate BPO Association
            $candidate = Candidate::where('user_id', auth()->id())->first();
            $candidate->update([
               'bpo_id' => $request->input('bpo_id')
            ]);

            return response()->json([
               'status' => true,
               'message' => 'New BPO Assigned'
            ]);
        }catch (\Exception $e){
            return response()->json([
                'status' => false,
                'message' => $e->getMessage()
            ]);
        }
    }
}
