<?php

namespace App\Http\Controllers\Api\Candidate;

use App\Http\Controllers\Controller;
use App\Models\JobApplication;
use App\Models\JobInterview;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class JobApplicationController extends Controller
{
    public function index()
    {
        //return all job applied by this candidate
        try {
            $jobs_applied = JobApplication::where('candidate_id', auth()->id())->get();
            return response()->json([
               'status' => true,
               'data' => $jobs_applied
            ]);
        }
        catch(\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }

    public function apply(Request $request)
    {
        //This function allows the candidate apply for a job
        try {
            $validator = Validator::make($request->all(), [
                'job_listing_id' => 'required',
                'candidate_id' => 'required',
                'employer_id' => 'required',
            ]);
            if ($validator->fails()){
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ]);
            }

            JobApplication::create([
               'job_listing_id' => $request->input('job_listing_id'),
               'candidate_id' => $request->input('candidate_id'),
               'employer_id' => $request->input('employer_id'),
               'interview_id' => $request->input('interview_id'),
               'status' => 'Pending',
            ]);

            return response()->json([
               'status' => true,
               'message' => 'You have successfully applied for the Job'
            ]);

        }catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }

    public function interview_acceptance(Request $request, $id)
    {
        try {
            $job_application = JobApplication::where('id', $id)->first();
            //The Candidate should choose Interview Accepted
            $job_application->update([
                'status' => $request->input('status')
            ]);
            //Return the response
            return response()->json([
                'status'=> true,
                'message' => 'Candidate Accepted Date for Interview'
            ]);
        } catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }

    }
    public function interview_rejection(Request $request, $id)
    {
        try {
            $job_application = JobApplication::where('id', $id)->first();

            //The Candidate should choose Interview Accepted
            $job_application->update([
                'status' => $request->input('status')
            ]);
            //Return the response
            return response()->json([
                'status'=> true,
                'message' => 'Candidate rejected Date for the Interview'
            ]);
        } catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }

    }

    public function offerAccepted(Request $request, $id)
    {
        try {
            $job_application = JobApplication::where('id', $id)->first();

            //The Candidate should choose Interview Accepted
            $job_application->update([
                'status' => $request->input('status')
            ]);
            //Return the response
            return response()->json([
                'status'=> true,
                'message' => 'Candidate Accepted by Candidate'
            ]);
        } catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }

    }

    public function offerRejected(Request $request, $id)
    {
        try {
            $job_application = JobApplication::where('id', $id)->first();

            //The Candidate should choose Interview Accepted
            $job_application->update([
                'status' => $request->input('status')
            ]);
            //Return the response
            return response()->json([
                'status'=> true,
                'message' => 'Candidate rejected this Offer'
            ]);
        } catch (\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }

    }

}
