<?php

namespace App\Http\Controllers\Api\Employer;

use App\Http\Controllers\Controller;
use App\Models\JobApplication;
use App\Models\JobInterview;
use Illuminate\Http\Request;

class JobApplicationInterviewController extends Controller
{
    public function interview(Request $request, $id)
    {
        try {
            //Get the JobApplicaton ID and get the Job Application
            //$job_application = JobApplication::with('employer', 'candidate', 'job_listing')->where('id', $id)->first();
            $job_application = JobApplication::where('id', $id)->first();

            //Update the status of the Job Application
            //The employer should choose Interview in Progress
            $job_application->update([
                'status' => $request->input('status')
            ]);

            //Update the Interview Date and title
            JobInterview::create([
                'title' => $request->input('title'),
                'job_application_id' => $job_application->id,
                'interview_date_time' => $request->input('interview_date_time')
            ]);

            /*@todo
                Send a message and an email to the candidate and also the BPO associated with the Candidate
            */
            //Return the response
            return response()->json([
                'status'=> true,
                'message' => 'Candidate invited for Interview'
            ]);
        }
        catch (\Exception $e){
            return response()->json([
                'status'=> false,
                'message' => $e->getMessage()
            ]);
        }
    }

    public function after_interview(Request $request, $id)
    {
        try {
            //Get the JobApplicaton ID and get the Job Application
            $job_application = JobApplication::where('id', $id)->first();

            //Update the status of the Job Application
            //The employer should choose either Offer Granted or Not Accepted

            $job_application->update([
                'status' => $request->input('status')
            ]);

            /*@todo
                Send a message and an email to the candidate and also the BPO associated with the Candidate
            */
            //Return the response
            return response()->json([
                'status'=> true,
                'message' => 'Status of Job Application Updated to either Offer Granted or Not Accepted'
            ]);
        }
        catch (\Exception $e){
            return response()->json([
                'status'=> false,
                'message' => $e->getMessage()
            ]);
        }
    }
}
