<?php

namespace App\Http\Controllers\Api\Employer;

use App\Http\Controllers\Controller;
use App\Models\Rating;
use App\Models\JobApplication;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;


class RatingsController extends Controller
{
    /**
     * Employer Rate Candidate after 60 Days and Job application status is Offer Granted.
     */
    public function candidate_rating(Request $request,$candidateid)
    {
    //validate job id input
       $request->validate(
        [
            'jobid'=>'required|min:1|max:10',
            'ratingpoint'=>'required|min:1|max:5',
            'comment'=>'required|min:1|max:500',
    
        ],
        [
            'jobid.required'=>'Job Id Field is required',
            'ratingpoint.required'=>'Rating Field is required',
            'comment.required'=>'Comment Field is required',
         
    ]);
     //Check for the data from the form
     $jobid = $request->input('jobid');
     $ratingpoint = $request->input('ratingpoint');
     $comment= $request->input('comment');

    //Fetch Job application where candidate status is Offered Granted and employer is the current Login Employer    
      $jobapplication = JobApplication::where('job_listing_id','=',$jobid)->where('candidate_id','=',$candidateid)->where('employer_id',auth()->user()->id)->first();
      $find_login_employer_job = $jobapplication->where(function($q){
        $q->where('status', '=', 'Offer Granted');
         
    })->first();

 
        if($find_login_employer_job){
        //Check if the Job Offer is up to 60 Days
            $current_time = Carbon::now();
            $current_time = $current_time->toDateTimeString();
            $diff_in_days = $find_login_employer_job->created_at->diffInDays($current_time);
            if($diff_in_days  < 6){
                return response()->json([
                    'status' => 'false',
                    'message' => 'You can only rate a candidate after 60 Days of Offer'
                ]);    
    
            }
       // Check if already Rated a candidate
        $candidate = Rating::where('candidate_id',$candidateid)->first();

        if($candidate){
            return response()->json([
                'status' => 'false',
                'message' => 'Already Rated this Candidate'
            ]);        
                 }else{
                    Rating::create([
                    'employer_id' => auth()->user()->id,
                    'candidate_id' => $jobapplication->candidate_id,
                    'job_listing_id' => $jobid,
                    'rating' => $ratingpoint,
                    'comment' => $comment,
                    'status' => '1',
           
            ]);

            return response()->json([
                'status' => 'true',
                'message' => 'Cadidate Successfully Rated'
            ]);
        }
    }

    }

    //Authenticated candidate see their ratings
    public function candidateviewrating()
    {
        try {
            //Get the data for rating and job application
            $candidate = auth()->user()->load('candidate');
            $job_applied = JobApplication::where('candidate_id', auth()->user()->id)->get();
            $rating = Rating::where('candidate_id', auth()->id())->get();
           
            //Geting the average of all rating score 
            $count = 0;
            $rating_count = 0;
            $total_rating = 0;

            foreach ($job_applied as $rating) {
                $rating = Rating::where('job_listing_id', $rating->job_listing_id)->where('candidate_id', auth()->user()->id)->first();
                if ($rating) {
                    $total_rating = $total_rating+$rating->rating;
                    $count = $count+1;
                    $rating_count = $rating_count + 1;
                }
            }
            $avg_rating = $count > 0 ? $total_rating/$count : 0;

            $data = [$job_applied, $rating];
            return response()->json([
                'status' => true, 
                'data' => $data,
                'average_rating'=>$avg_rating,
            ]);
        }catch(\Exception $e){
            return response()->json([
                'status' => false,
                'data' => $e->getMessage()
            ]);
        }
    }
    
    //View a candidate rating with ID
    public function viewcandidate_rating(Request $request, $candidateid)
    {
      
          //fetch candidate with the ID provided 
            $user = User::with('candidate')
            ->select(['id','firstname','lastname'])
            ->where('status', 'approved')->where('id', $candidateid)
            ->first();
        if($user) {
            //fetching the job offer granted for a candidate 
            $jobrating_application = JobApplication::select('id', 'job_listing_id','candidate_id', 'status')->where('candidate_id', $user->id)->where('status', 'Offer Granted')->latest()->get();

            $fullname = $user->firstname." ".$user->lastname; //concatinating the full name of candidate
            
            //Iterating through all the ratings of candidate and geting the total rating and average of rating
            $count = 0;
            $rating_count = 0;
            $total_rating = 0;

            foreach ($jobrating_application as $rating) {
                $rating = Rating::where('job_listing_id', $rating->job_listing_id)->where('candidate_id', $user->id)->first();
                if ($rating) {
                    $total_rating = $total_rating+$rating->rating;
                    $count = $count+1;
                    $rating_count = $rating_count + 1;
                }
            }
            $avg_rating = $count > 0 ? $total_rating/$count : 0;
            
            //candidate rating
            $review_rating = [];
            $review_feedback= [];
            //assigning the ratings
            foreach($jobrating_application as $key => $rating) {
                $rating = Rating::where('job_listing_id', $rating->job_listing_id)->where('candidate_id', $user->id)->first();
                if(!empty($rating)){
                    $review_rating[] = $rating->rating;
                    $review_feedback[] = $rating->comment;
                }
            }

            return response()->json([
                'name' => $fullname,
                'avg_rating' => $avg_rating,
                'rating_total' => $rating_count,
                'rating' => $review_rating,
                'rating_comment' => $review_feedback,
                'job_application' => $jobrating_application,
            ]);
        }else{
            return response()->json(['msg' => __('candidate not found')]);
        }
    }

    
}
