<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\JobListing;
use Illuminate\Http\Request;

class JobSearchController extends Controller
{
    public function index(Request $request)
    {
        try {
            //get the search request from the candidate/bpo and employee
            $jobListings = JobListing::where('title', 'like', '%'. $request->input('search', ).'%')->with('employer')->get();
            return response()->json([
                'status' => true,
                'data' => $jobListings
            ]);
        }catch (\Exception $e){
            return response()->json([
               'status' => false,
               'message' => $e->getMessage()
            ]);
        }
    }

    public function featured()
    {
        try {
            //fetch all Job Listings
            $job_listings = JobListing::with('employer')->limit(3)->get();
            return response()->json([
               'status' => true,
               'data' => $job_listings
            ]);
        }catch (\Exception $e)
        {
            return response()->json([
               'status' => false,
               'message' => $e->getMessage()
            ]);
        }
    }

    public function jobdetails($id){

        //Get the Job details by ID
        try {
            //fetch all Job Listings
            $job_details = JobListing::where('id', $id)->first();
            return response()->json([
               'status' => true,
               'data' => $job_details
            ]);
        }catch (\Exception $e)
        {
            return response()->json([
               'status' => false,
               'message' => $e->getMessage()
            ]);
        }

    }

}
