<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\JobListing;
use App\Models\JobCategories;
use Illuminate\Http\Request;
use PhpParser\Node\Expr\FuncCall;

class JobsController extends Controller
{
    public function index()
    {
        try {
            //fetch all Job Listings
            $job_listings = JobListing::with('employer')->get();
            return response()->json([
               'status' => true,
               'data' => $job_listings
            ]);
        }catch (\Exception $e)
        {
            return response()->json([
               'status' => false,
               'message' => $e->getMessage()
            ]);
        }
    }

    public function jobcategories ()
    {
        try {

            //Get all the BPO's on the Platform and return the data so that the Candidate can use
            $categories = JobCategories::all();
            return response()->json([
                    'status' => true,
                    'data' => $categories
                ]);
            }catch (\Exception $e){
                return response()->json([
                    'status' => false,
                    'message' => $e->getMessage()
                ]);
            }
    }

}
