<?php

namespace App\Http\Controllers\Api\Messages;

use App\Http\Controllers\Controller;
use App\Models\Message;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class MessageController extends Controller
{
    public function sent_messages()
    {
        try{
            //Get the ID of the current login user, use that to fetch
            $sent_messages = Message::with('sender_details', 'receiver_details')->where('sender_id', auth()->id())->get();
            return response()->json([
               'status' => true,
               'data' => $sent_messages
            ]);
        }catch (\Exception $e){
            return response()->json([
               'status'=>false,
               'message' => $e->getMessage()
            ]);
        }
    }

    public function received_messages(): \Illuminate\Http\JsonResponse
    {
        try{
            //Get the ID of the current login user, use that to fetch
            $receiver_messages = Message::with('receiver_details', 'sender_details')->where('receiver_id', auth()->id())->get();
            return response()->json([
                'status' => true,
                'data' => $receiver_messages
            ]);
        }catch (\Exception $e){
            return response()->json([
                'status'=>false,
                'message' => $e->getMessage()
            ]);
        }
    }

    public function create(Request $request)
    {
        try {
            //Validate the Request from the form
            $validator = Validator::make($request->all(), [
                'receiver_id' => 'required',
                'title' => 'required',
                'body' => 'required',
            ]);
            if ($validator->fails()){
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ]);
            }

            Message::create([
               'sender_id' => auth()->id(),
               'receiver_id' => $request->input('receiver_id'),
               'title' => $request->input('title'),
               'body' => $request->input('body'),
               'status' => 'Message Sent',
            ]);

            return response()->json([
               'status' => true,
               'message' => 'Message sent successfully'
            ]);


        }catch (\Exception $e){
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }

    public function reply(Request $request, $id)
    {
        try {
            //Get the Message through the ID
            $message = Message::findOrFail($id);
            if ($message) {
                //Reply to the message and create a new message
                Message::create([
                    'sender_id' => auth()->id(),
                    'receiver_id' => $message->receiver_id,
                    'title' => $request->input('title'),
                    'body' => $request->input('body'),
                    'status' => 'Message Replied',
                    'reply_to_id' => $message->id,
                ]);

                return response()->json([
                    'status' => true,
                    'message' => 'Message Replied successfully'
                ]);
            }
        }catch (\Exception $e){
            return response()->json([
                'status'=>false,
                'message' => $e->getMessage()
            ]);
        }
    }
}
