<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = ['sender_id', 'receiver_id', 'title', 'body', 'status','reply_to_id'];

    public function sender_details()
    {
        return $this->belongsTo(User::class, 'sender_id', 'id');
    }

    public function receiver_details()
    {
        return $this->belongsTo(User::class, 'receiver_id', 'id');
    }
}
