<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ratings', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('employer_id');
            $table->bigInteger('candidate_id');
            $table->bigInteger('job_listing_id')->unsigned();
            $table->integer('rating');
            $table->text('comment')->nullable();
            $table->tinyInteger('status')->default(0)->comment('1=active 0=inactive');
            $table->timestamps();
            $table->foreign('job_listing_id')
            ->references('id')
            ->on('job_listings')
            ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ratings');
    }
};
