<?php

use App\Http\Controllers\Api\BPO\BPOHomeController;
use App\Http\Controllers\Api\Candidate\CandidateBPOController;
use App\Http\Controllers\Api\Candidate\JobApplicationController;
use App\Http\Controllers\Api\Employer\JobApplicationInterviewController;
use App\Http\Controllers\Api\Employer\JobListingController;
use App\Http\Controllers\API\Employer\RatingsController;
use App\Http\Controllers\API\Employers\HomeController;
use App\Http\Controllers\API\JobsController;
use App\Http\Controllers\Api\JobSearchController;
use App\Http\Controllers\Api\Messages\MessageController;
use App\Http\Controllers\Api\Admin\UserListingsController;
use \App\Http\Controllers\Api\Admin\ApprovesController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::get('/candidate/jobs', [JobsController::class, 'index']);
Route::get('/jobs/categories', [JobsController::class, 'jobcategories']);
Route::get('/jobs/search', [JobSearchController::class, 'index']);
Route::get('/jobs/view/{jobid}', [JobSearchController::class, 'jobdetails']);
Route::get('/jobs/featured', [JobSearchController::class, 'featured']);



Route::group(['middleware' => ['auth:sanctum']], function(){
    //Route::post('/auth/register', [AuthController::class, 'register'])->middleware('restrictRole:admin');
    
    //Routes for Admin
    Route::get('/admin/viewusers', [UserListingsController::class, 'viewallusers'])->middleware('restrictRole:admin');
    Route::get('/admin/candidate/view', [UserListingsController::class, 'viewcandidate'])->middleware('restrictRole:admin');
    Route::get('/admin/employer/view', [UserListingsController::class, 'viewemployer'])->middleware('restrictRole:admin');
    Route::get('/admin/bpo/view', [UserListingsController::class, 'viewbpo'])->middleware('restrictRole:admin');
    Route::put('/admin/viewusers/update/{id}',  [UserListingsController::class, 'user_update'])->middleware('restrictRole:admin');
    Route::delete('/admin/viewusers/destroy/{id}', [UserListingsController::class, 'destroy'])->middleware('restrictRole:admin');
    Route::put('/admin/candidate/approve/{id}', [ApprovesController::class, 'candidate_approve'])->middleware('restrictRole:admin');
    Route::put('/admin/employer/approve/{id}', [ApprovesController::class, 'employer_approve'])->middleware('restrictRole:admin');
    Route::put('/admin/bpo/approve/{id}', [ApprovesController::class, 'bpo_approve'])->middleware('restrictRole:admin');
  

    //Route for Messaging
    Route::get('/messages/sent/all/', [MessageController::class, 'sent_messages'])->middleware('restrictRole:employer,admin,candidate,bpo');
    Route::get('/messages/received/all', [MessageController::class, 'received_messages'])->middleware('restrictRole:employer,admin,candidate,bpo');
    Route::post('/messages/new', [MessageController::class, 'create'])->middleware('restrictRole:employer,admin,candidate,bpo');
    Route::post('/messages/reply/{id}', [MessageController::class, 'reply'])->middleware('restrictRole:employer,admin,candidate,bpo');


    //Routes for Employer
    Route::get('/employer/dashboard', [HomeController::class, 'index'])->middleware('restrictRole:employer');
    Route::get('/employer/joblistings', [JobListingController::class, 'index'])->middleware('restrictRole:employer');
    Route::post('/employer/joblistings/create', [JobListingController::class, 'create'])->middleware('restrictRole:employer');
    Route::put('/employer/joblistings/update/{id}', [JobListingController::class, 'update'])->middleware('restrictRole:employer');
    Route::delete('/employer/joblistings/destroy/{id}', [JobListingController::class, 'destroy'])->middleware('restrictRole:employer');

    Route::get('/employer/profile', [HomeController::class, 'profile'])->middleware('restrictRole:employer');
    Route::put('/employer/profile/update/{id}', [HomeController::class, 'profile_update'])->middleware('restrictRole:employer');
    Route::put('/employer/candidates/interview/{id}', [JobApplicationInterviewController::class, 'interview'])->middleware('restrictRole:employer');
    //Route for Employer after Interview. This is responsible for updating the status of the Job Application
    Route::put('/employer/candidates/interview/after/{id}', [JobApplicationInterviewController::class, 'after_interview'])->middleware('restrictRole:employer');

    //Routes for Employer Rating candidate with ID
    Route::post('/employer/rating/{candidateid}', [RatingsController::class, 'candidate_rating'])->middleware('restrictRole:employer');
    //Route to view candidate rating details by ID
    Route::get('/candidate/rating/view/{candidateid}', [RatingsController::class, 'viewcandidate_rating'])->middleware('restrictRole:employer,admin,candidate,bpo');
    //Route for authenticated candidate to see their rating
    Route::get('/candidate/rating/view', [RatingsController::class, 'candidateviewrating'])->middleware('restrictRole:candidate');

    //Routes for candidate
    Route::get('/candidate/dashboard', [\App\Http\Controllers\Api\Candidate\HomeController::class, 'index'])->middleware('restrictRole:candidate');
    Route::get('/candidate/profile', [\App\Http\Controllers\Api\Candidate\HomeController::class, 'profile'])->middleware('restrictRole:candidate');
    Route::put('/candidate/profile/update/{id}', [\App\Http\Controllers\Api\Candidate\HomeController::class, 'profile_update'])->middleware('restrictRole:candidate');

    Route::get('/candidate/bpo/all', [CandidateBPOController::class, 'allBpo'])->middleware('restrictRole:candidate');
    Route::post('/candidate/update/bpo', [CandidateBPOController::class, 'updateBPO'])->middleware('restrictRole:candidate');

    Route::get('/candidate/jobs', [JobsController::class, 'index'])->middleware('restrictRole:candidate');
    Route::get('/candidate/jobs/applied', [JobApplicationController::class, 'index'])->middleware('restrictRole:candidate');
    Route::post('/candidate/jobs/apply', [JobApplicationController::class, 'apply'])->middleware('restrictRole:candidate');
    Route::put('/candidate/jobs/interview/acceptance/{id}', [JobApplicationController::class, 'interview_acceptance'])->middleware('restrictRole:candidate');
    Route::put('/candidate/jobs/interview/rejection/{id}', [JobApplicationController::class, 'interview_rejection'])->middleware('restrictRole:candidate');
    Route::put('/candidate/jobs/interview/offer/accepted/{id}', [JobApplicationController::class, 'offerAccepted'])->middleware('restrictRole:candidate');
    Route::put('/candidate/jobs/interview/offer/rejected/{id}', [JobApplicationController::class, 'offerRejected'])->middleware('restrictRole:candidate');

    //Routes for BPO's
    Route::get('/bpo/dashboard', [BPOHomeController::class, 'index'])->middleware('restrictRole:bpo');
    Route::get('/bpo/profile', [BPOHomeController::class, 'profile'])->middleware('restrictRole:bpo');


});


/*===========================
=           employers           =
=============================*/

//Route::apiResource('/employers', \App\Http\Controllers\API\EmployerController::class);

/*=====  End of employers   ======*/

/*===========================
=           candidates           =
=============================*/
Route::get('register/data', '\App\Http\Controllers\API\Candidate\Auth\RegistrationController@registration_data');
Route::post('register', '\App\Http\Controllers\API\Candidate\Auth\RegistrationController@register');
Route::post('login', '\App\Http\Controllers\API\Auth\LoginController@login');

//Employers API routes
//Route::get('/employer/dashboard', '\App\Http\Controllers\API\Employers\HomeController@index');
//Route::apiResource('/candidates', \App\Http\Controllers\API\CandidateController::class);

/*=====  End of candidates   ======*/

/*===========================
=           employers           =
=============================*/

//Route::apiResource('/employers', \App\Http\Controllers\API\EmployerController::class);

/*=====  End of employers   ======*/

/*===========================
=           bPOS           =
=============================*/

//Route::apiResource('/bPOS', \App\Http\Controllers\API\BPOController::class);

/*=====  End of bPOS   ======*/

/*===========================
=           employers           =
=============================*/

//Route::apiResource('/employers', \App\Http\Controllers\API\EmployerController::class);

/*=====  End of employers   ======*/

/*===========================
=           jobPostings           =
=============================*/

//Route::apiResource('/jobPostings', \App\Http\Controllers\API\JobPostingController::class);

/*=====  End of jobPostings   ======*/
