# Contributing to the Laravel API Toolkit

Thank you for considering contributing to the Laravel API Toolkit! We welcome your contributions to help make this package even better. Please take a moment to review this document to understand how you can contribute effectively.

## How Can You Contribute?

There are several ways you can contribute to this project:

1. Reporting Issues:
   - If you encounter a bug or have a suggestion for an improvement, please [open an issue](https://github.com/ahmedesa/laravel-api-tool-kit/issues) on GitHub. Be sure to provide detailed information about the problem or enhancement request.

2. Submitting Pull Requests:
   - If you'd like to contribute code, we encourage you to submit a pull request (PR). Here's how:
     - Fork the repository on GitHub.
     - Clone the forked repository to your local machine.
     - Create a new branch for your changes: `git checkout -b feature/your-feature-name`.
     - Make your changes and commit them with clear and concise messages.
     - Push your branch to your forked repository: `git push origin feature/your-feature-name`.
     - Create a pull request from your branch to the main repository's `master` branch.
     - Ensure that your PR includes a clear description of the changes made and why they are necessary.

3. Improving Documentation:
   - Documentation is essential. If you find areas in the documentation that need improvement or have suggestions to make it more understandable, please submit a PR to [the Laravel API Toolkit Docs](https://github.com/ahmedesa/laravel-api-tool-kit-docs) repository with your changes.

4. Providing Feedback:
   - Share your experiences using the Laravel API Toolkit. Your feedback helps us understand what works well and what can be improved.

## Code Style and Guidelines

To maintain code consistency and readability, please follow these guidelines:

- Adhere to the [PSR-2 coding style](https://www.php-fig.org/psr/psr-2/).
- Write clear and concise code and comments.
- Ensure your code is well-tested. You can run tests using `composer test`.
- Keep your commits and pull requests focused on a single issue or feature.
- Document any change in behavior in the README.md and any other relevant documentation.

Thank you for contributing to the Laravel API Toolkit!

